package cn.com.duiba.live.activity.center.api.remoteservice.flipword;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.flipword.LiveFlipWordRedConfigDto;

import java.util.List;

/**
 * 翻牌集字红包配置
 *
 * @author chenh
 * @date 2021-11-10 13:41:15
 */
@AdvancedFeignClient
public interface RemoteLiveFlipWordRedConfigService {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    LiveFlipWordRedConfigDto queryById(Long id);

    /**
     * 新增数据
     *
     * @param liveFlipWordRedConfigDto 实例对象
     * @return 影响行数
     */
    Long insert(LiveFlipWordRedConfigDto liveFlipWordRedConfigDto);

    /**
     * 修改数据
     *
     * @param liveFlipWordRedConfigDto 实例对象
     * @return 影响行数
     */
    int update(LiveFlipWordRedConfigDto liveFlipWordRedConfigDto);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 影响行数
     */
    int deleteById(Long id);

    /**
     * 批量新增数据
     *
     * @param liveFlipWordRedConfigDto 实例对象
     * @return 影响行数
     */
    Integer batchInsert(List<LiveFlipWordRedConfigDto> liveFlipWordRedConfigDto);

    /**
     * 通过configId查询
     *
     * @param configId 主键
     * @return 实例对象
     */
    List<LiveFlipWordRedConfigDto> selectByConfigId(Long configId);

}
