package cn.com.duiba.live.activity.center.api.remoteservice.lottery;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.lottery.LiveLotteryCodeDto;
import cn.com.duiba.live.activity.center.api.dto.lottery.LiveLotteryUserCodeDto;
import cn.com.duiba.live.activity.center.api.param.lottery.LiveLotteryCodeSearchParam;

import java.util.List;
import java.util.Map;

/**
 * 抽奖码
 * @author lizhi
 * @date 2020/6/3 1:53 PM
 */
@AdvancedFeignClient
public interface RemoteLiveLotteryCodeService {

    /**
     * 根据主键批量查询
     * @param ids 主键集合
     * @return 抽奖码集合
     */
    List<LiveLotteryCodeDto> findByIds(List<Long> ids);

    /**
     * 查询未使用的抽奖码
     * @param liveId 直播ID
     * @param liveVisitorIdList 直播用户ID集合
     * @return key：直播用户ID，value：抽奖码主键集合
     */
    Map<Long, List<Long>> findVisitorNotUsedIds(Long liveId, List<Long> liveVisitorIdList);

    /**
     * 查询未使用抽奖码数量
     * @param liveId 直播ID
     * @param liveVisitorIdList 直播用户ID集合
     * @return key：直播用户ID，value：数量
     */
    Map<Long, Long> findVisitorNotUsedCount(Long liveId, List<Long> liveVisitorIdList);

    /**
     * 批量插入抽奖码
     * @param dtoList 抽奖码集合
     * @return 用户ID及抽奖码ID
     */
    List<LiveLotteryUserCodeDto> batchInsert(List<LiveLotteryCodeDto> dtoList);

    /**
     * 批量更改为已使用
     * @param ids 主键
     * @return 执行结果
     */
    int batchUseCode(List<Long> ids);

    /**
     * 根据直播ID 和 用户ID 查询列表
     * @return
     */
    List<LiveLotteryCodeDto> findByLiveIdAndUserId(LiveLotteryCodeSearchParam param);

    /**
     *查询数量
     * @param param
     * @return
     */
    long selectCount(LiveLotteryCodeSearchParam param);

    /**
     * 查询一个直播下某种类型的抽奖券，一批用户的领取数量
     * @param liveId
     * @param liveUserIds
     * @param codeSource
     * @return key: liveUserId； value：数量
     */
    Map<Long,Long> selectOneSourceLotteryCodeNumByLiveIdAndUserIds(Long liveId, List<Long> liveUserIds, Integer codeSource);
}
