package cn.com.duiba.live.activity.center.api.remoteservice.rights;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.rights.RightsRecordDto;
import cn.com.duiba.live.activity.center.api.param.right.RightsRecordParam;

import java.util.List;

@AdvancedFeignClient
public interface RemoteRightsRecordService {


    /**
     * 查询数量
     * @param creditRightsId
     * @return
     */
    Long countByParam(Long creditRightsId);

    /**
     * 根据creditRightsId查询
     * @param creditRightsId
     * @return
     */
    List<RightsRecordDto> getByCreditRightsId(Long creditRightsId);

    /**
     * 删除
     * @param creditRightsId
     * @return
     */
    int deleteByCreditRightsId(Long creditRightsId);

    /**
     * 保存
     * @param rightsRecordDto
     * @return
     */
    long save(RightsRecordDto rightsRecordDto);

    /**
     * 保存
     * @param rightsRecordDtos
     * @return
     */
    long saveList(List<RightsRecordDto> rightsRecordDtos);

    /**
     * 查询数量
     * @param rightsRecordParam
     * @return
     */
    Long selectCount(RightsRecordParam rightsRecordParam);
}
