package cn.com.duiba.live.activity.center.api.dto.fission.blindbox;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
* 盲盒抽奖记录表
 * @author chenhang
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class BlindBoxRecordDto implements Serializable {

    private static final long serialVersionUID = 5556273745290411248L;
    /**
    * 活动ID
    */
    private Long activityId;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModified;

    /**
    * 商品ID
    */
    private Long goodsId;

    /**
    * 主键
    */
    private Long id;

    /**
    * 直播ID
    */
    private Long liveId;

    /**
    * 直播用户ID
    */
    private Long liveUserId;

    /**
    * 领取状态：0 待领取 1:领取成功
    */
    private Integer receiveStatus;

    /**
    * 状态变更时间
    */
    private Date statusTime;

    /**
     * 规则id
     */
    private Long ruleId;

    /**
     * 盲盒id
     */
    private Long blindBoxId;

    /**
     * 开盲盒时限制的人数
     */
    private Integer openNum;
}

