package cn.com.duiba.live.activity.center.api.enums.flipword;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author zhuenhui
 * @date 2021/06/29 2:50 下午
 * @description 翻牌集字配置状态
 */
@Getter
@AllArgsConstructor
public enum FlipWordConfStatusEnum {

    CLOSED(1, "未开启"),
    OPEN(2, "已开启"),
    OFF_SHELF(3, "已下架"),
    ;

    private final Integer status;
    private final String desc;

    private static  final Map<Integer, FlipWordConfStatusEnum> ENUM_MAP;

    static {
        ENUM_MAP = Arrays.stream(FlipWordConfStatusEnum.values()).collect(Collectors.toMap(FlipWordConfStatusEnum::getStatus, Function.identity()));
    }

    public static FlipWordConfStatusEnum getByStatus(Integer status) {
        if (status == null) {
            return null;
        }
        return ENUM_MAP.get(status);
    }

}
