package cn.com.duiba.live.activity.center.api.enums.flipword;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author zhuenhui
 * @date 2021/06/29 9:30 下午
 * @description 翻牌集字 - 翻牌结果类型
 */
@Getter
@AllArgsConstructor
public enum FlipWordResultTypeEnum {
    THANKS(0, "谢谢参与"),
    CARD_FU(1, "福"),
    CARD_LU(2, "禄"),
    CARD_SHOU(3, "寿"),
    CARD_XI(4, "禧"),
    CARD_CAI(5, "财");
    private final Integer code;
    private final String desc;

    public static boolean isWord(Integer code) {
        if (code == null) {
            return false;
        }
        return !THANKS.getCode().equals(code);
    }
}