package cn.com.duiba.live.activity.center.api.remoteservice.fission.achieve;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.fission.achieve.FissionAchieveActivityDto;
import cn.com.duiba.live.activity.center.api.dto.fission.achieve.FissionActivityDto;
import cn.com.duiba.live.activity.center.api.param.fission.FissionActivitySearchParam;

import java.util.List;

/**
 * 裂变活动-达标必得
 * @author ouyang
 * @date 2021/8/6 19:18
 */
@AdvancedFeignClient
public interface RemoteFissionAchieveActivityService {

    /**
     * 达标必得活动信息 （商品信息分页）
     * @param param 查询参数
     * @return 达标必得dto
     */
    FissionAchieveActivityDto getOne (FissionActivitySearchParam param);


    List<FissionActivityDto> findByIds (List<Long> ids);

    /**
     * 删除活动（多表操作）
     * @param activityId 活动id
     * @return Boolean
     */
    boolean delete (Long activityId);

}
