package cn.com.duiba.live.activity.center.api.remoteservice.guide;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.guide.LiveGuideBoomAppointmentDto;
import cn.com.duiba.live.activity.center.api.dto.guide.LiveGuideBoomNumDto;
import cn.com.duiba.live.activity.center.api.param.guide.LiveGuideAppointmentParam;

import java.util.List;

/**
 * @Author xujing
 * @Date 2020/12/5 10:30 上午
 */
@AdvancedFeignClient
public interface RemoteLiveGuideBoomAppointmentService {

    /**
     * 统计用户预约数量
     * @param liveId
     * @param liveUserId
     * @return
     */
    Integer countUserAppointmentNum(Long liveId,Long liveUserId);


    /**
     * 统计当前直播所有预约商品的预约数量
     * @param liveId
     * @return
     */
    List<LiveGuideBoomNumDto> countLiveGuideBoomNum(Long liveId);

    /**
     * 查询当前用户预约的预约记录
     *
     * @param liveId
     * @return
     */
    List<LiveGuideBoomAppointmentDto> listUserRecord(Long liveId, Long liveUserId);

    /**
     * 分页获取 某个商品预约记录
     * @param param
     * @return
     */
    List<LiveGuideBoomAppointmentDto> pageInteractAppointmentRecord(LiveGuideAppointmentParam param);

    /**
     * 批量标记推送
     * @param liveId 直播ID
     * @param interactId 互动ID
     * @param liveUserIds 用户
     * @return
     */
    Integer batchMarkPush(Long liveId, Long interactId, List<Long> liveUserIds);


    /**
     * 插入一条数据
     *
     * @return
     */
    Long insert(LiveGuideBoomAppointmentDto liveGuideBoomAppointmentDto);


}
