package cn.com.duiba.live.activity.center.api.remoteservice.multiprize;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.lottery.LiveMultiPrizeLotteryCollectDto;
import cn.com.duiba.live.activity.center.api.dto.lottery.LiveRewardLotteryRealResultDto;
import cn.com.duiba.live.activity.center.api.dto.lottery.LiveRewardLotteryResultDto;
import com.google.common.collect.Table;
import org.apache.commons.lang3.tuple.Pair;

import java.util.List;
import java.util.Map;

/**
 * @author chengsiyi
 * @date 2021/6/2 19:35
 */
@AdvancedFeignClient
public interface RemoteLiveMultiPrizeLotteryService {

    /**
     * 开始收集
     * @param liveId
     */
    void startCollect(Long liveId);

    /**
     * 结束收集
     * @param liveId
     */
    void stopCollect(Long liveId);

    /**
     * 收集在线用户
     * @param list 用户信息
     */
    void collect(List<LiveMultiPrizeLotteryCollectDto> list);

    /**
     * 预热抽奖，将用户添加到抽奖池中
     * @param list 用户信息
     */
    void preCollect(List<LiveMultiPrizeLotteryCollectDto> list);

    /**
     * 异步执行抽奖任务
     * @param liveId 直播ID
     * @param confId 福利配置ID
     * @param topic 回调的mq的topic
     * @param tag 回调的mq的tag
     *            回调内容结构 {"liveId":1,"confId":2}
     */
    void asyncDrawAndSendMq(Long liveId, Long confId, String topic, String tag);

    /**
     * 获取中奖人数，从redis缓存查询
     *
     * @param liveId 直播ID
     * @param confId 福利配置ID
     * @return optionId, boolean, count 中奖人数，注意：可为null，为null说明redis中没有值
     * boolean = true,真实发放数量，不含马甲
     * boolean = false,虚拟发放数量
     */
    Table<Long, Boolean, Integer> getLotteryCount(Long liveId, Long confId);


    /**
     * 获取真实中奖人列表，从redis缓存查询
     *
     * @param liveId 直播ID
     * @param confId 福利配置ID
     * @return 真实中奖人列表，注意：可为null，为null说明redis中没有值
     */
    List<LiveRewardLotteryRealResultDto> getRealResultList(Long liveId, Long confId);

    /**
     * 获取真实中奖人列表-分页，每页条数为1000，从redis缓存查询
     *
     * @param liveId 直播ID
     * @param confId 福利配置ID
     * @param pageIndex 页码
     * @return 真实中奖人列表，注意：可为null，为null说明redis中没有值
     */
    List<LiveRewardLotteryRealResultDto> getRealResultPage(Long liveId, Long confId, int pageIndex);

    /**
     * 获取中奖名单（包含马甲，最多200条），从redis缓存查询
     *
     * @param liveId 直播ID
     * @param confId 福利配置ID
     * @return 中奖名单，注意：可为null，为null说明redis中没有值
     */
    List<LiveRewardLotteryResultDto> getAllResultList(Long liveId, Long confId);

    /**
     * 获取中奖用户昵称名单（包含马甲，最多200条），从redis缓存查询
     *
     * @param liveId 直播ID
     * @param confId 福利配置ID
     * @return 中奖用户昵称名单，注意：可为null，为null说明redis中没有值
     */
    List<String> getAllResultNameList(Long liveId, Long confId);

    /**
     * 下一场抽奖间隔时间
     * @param liveId 直播ID
     * @param companyId 公司ID
     * @return
     */
    Pair<Boolean, Long> getNextLotteryDuration(Long liveId, Long companyId);
}
