package cn.com.duiba.live.activity.center.api.remoteservice.collect;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.collect.LiveUserCollectDto;

import java.util.List;

/**
 * @author chengsiyi
 * @date 2021/6/21 19:53
 */
@AdvancedFeignClient
public interface RemoteLiveUserCollectService {

    /**
     * 获取采集用户类型
     * @param liveId 直播ID
     * @return {@link cn.com.duiba.live.activity.center.api.enums.UserCollectTypeEnum}
     */
    Integer getCollectType(Long liveId);

    /**
     * 收集用户信息
     * @param collectType 收集类型
     * @param userList 用户信息
     */
    void collect(Integer collectType, List<LiveUserCollectDto> userList);
}
