package cn.com.duiba.live.activity.center.api.enums.fission;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author chenhang
 * @date 2021/11/26 6:31 下午
 */
@Getter
@AllArgsConstructor
public enum BlindBoxTypeEnum {
    BLIND_TYPE_FREE(0, "免费领");

    private final Integer status;
    private final String desc;

    private static  final Map<Integer, BlindBoxTypeEnum> ENUM_MAP;

    static {
        ENUM_MAP = Arrays.stream(BlindBoxTypeEnum.values()).collect(Collectors.toMap(BlindBoxTypeEnum::getStatus, Function.identity()));
    }

    public static BlindBoxTypeEnum getByStatus(Integer status) {
        if (status == null) {
            return null;
        }
        return ENUM_MAP.get(status);
    }

}
