package cn.com.duiba.live.activity.center.api.remoteservice.operation;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.kjy.api.params.Page;
import cn.com.duiba.live.activity.center.api.dto.operation.PayOperationDto;
import cn.com.duiba.live.activity.center.api.param.operation.PayOperationQueryParam;

/**
 * @author chenhang
 * @date 2021/8/3 2:00 下午
 */
@AdvancedFeignClient
public interface RemotePayOperationService {

    /**
     * 根据条件查询列表
     * @param param 参数
     * @return 列表
     */
    Page<PayOperationDto> queryPage(PayOperationQueryParam param);


    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    PayOperationDto queryById(Long id);


    /**
     * 新增数据
     *
     * @param payOperationDto 对象
     * @return 实例对象
     */
    void save(PayOperationDto payOperationDto);

    /**
     * 修改数据
     *
     * @param payOperationDto 实例对象
     * @return 实例对象
     */
    void update(PayOperationDto payOperationDto);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    void deleteById(Long id);

}
