package cn.com.duiba.live.activity.center.api.remoteservice.rights;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.rights.CreditRightsCollectionDto;
import cn.com.duiba.live.activity.center.api.param.rights.CreditRightsCollecionSearchParam;

import java.util.List;

@AdvancedFeignClient
public interface RemoteCreditRightsCollectionService {

    /**
     * 查询数量
     * @param param
     * @return
     */
    Long countByParam(CreditRightsCollecionSearchParam param);

    /**
     * 分页查询
     * @param param
     * @return
     */
    List<CreditRightsCollectionDto> pageByParam(CreditRightsCollecionSearchParam param);

    /**
     * 删除
     * @param id
     * @return
     */
    int deleteById(Long id);

    /**
     * 根据id查询
     * @param id
     * @return
     */
    CreditRightsCollectionDto getById(Long id);

    /**
     * 保存
     * @param creditRightsCollectionDto
     * @return
     */
    long save(CreditRightsCollectionDto creditRightsCollectionDto);

    /**
     * 修改
     * @param creditRightsCollectionDto
     * @return
     */
    long update(CreditRightsCollectionDto creditRightsCollectionDto);
}
