package cn.com.duiba.live.activity.center.api.remoteservice.scene;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.scene.LiveActivityExtDto;
import cn.com.duiba.live.activity.center.api.param.scene.ActivityExtParam;

import java.util.List;

/**
 * 活动场景扩展
 * @author ouyang
 * @date 2021/8/4 19:18
 */
@AdvancedFeignClient
public interface RemoteLiveActivityExtService {

    /**
     * 根据主键查询
     * @param id 主键
     * @return 直播结束页配置
     */
    LiveActivityExtDto selectById(Long id);


    /**
     * 根据条件查询
     * @param param 查询条件
     * @return 直播结束页配置
     */
    List<LiveActivityExtDto> selectByParam(ActivityExtParam param);


    /**
     * 新增/编辑
     * @param dto 直播结束页
     * @return true-成功 false-失败
     */
    boolean saveOrUpdate(LiveActivityExtDto dto);

    /**
     * 物理删除
     * @param id 主键
     * @return 执行结果
     */
    boolean delete(Long id);

}
