package cn.com.duiba.live.activity.center.api.remoteservice.fission.blindbox;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.fission.blindbox.BlindBoxGoodsRuleDto;
import cn.com.duiba.live.activity.center.api.param.fission.BlindBoxGoodsRuleSearchParam;

import java.util.List;

/***
 * @author chenhang
 * @since 2021-11-25 15:23:17
 */
@AdvancedFeignClient
public interface RemoteBlindBoxGoodsRuleService {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    BlindBoxGoodsRuleDto queryById(Long id);

    /**
     * 新增数据
     *
     * @param dto 实例对象
     * @return 实例对象
     */
    Long insert(BlindBoxGoodsRuleDto dto);

    /**
     * 修改数据
     *
     * @param dto 实例对象
     * @return 实例对象
     */
    int update(BlindBoxGoodsRuleDto dto);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    int deleteById(Long id);


    /**
     * 根据条件获取盲盒规则
     * @param searchParam 查询条件
     * @return 结果
     */
    List<BlindBoxGoodsRuleDto> selectByParam(BlindBoxGoodsRuleSearchParam searchParam);


    /**
     * 根据商品id删除,对应的商品发奖规则
     * @param configId
     * @return 删除数量
     */
    Long deleteByConfigId(Long configId);

}
