package cn.com.duiba.live.activity.center.api.remoteservice.flipword;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.flipword.LiveFlipWordConfigDto;
import cn.com.duiba.live.activity.center.api.dto.flipword.LiveFlipWordStepConfDto;

/***
 * @author chenh
 * @date  2021-11-10 13:41:09
 */
@AdvancedFeignClient
public interface RemoteLiveFlipWordConfigService {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    LiveFlipWordConfigDto queryById(Long id);

    /**
     * 新增数据
     *
     * @param liveFlipWordConfigDto 实例对象
     * @return 影响行数
     */
    Long insert(LiveFlipWordConfigDto liveFlipWordConfigDto);

    /**
     * 修改数据
     * @param liveFlipWordConfigDto 实例对象
     * @return 影响行数
     */
    int update(LiveFlipWordConfigDto liveFlipWordConfigDto);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 影响行数
     */
    int deleteById(Long id);

    /**
     * 根据直播id获取翻牌集字配置详情
     * @param liveId 直播Id
     * @return 配置详情
     */
    LiveFlipWordStepConfDto getFlipWordDetail(Long liveId);

    /**
     * 通过ID查询单条数据
     *
     * @param activityId 主键
     * @return 实例对象
     */
    LiveFlipWordConfigDto selectByActivityId(Long activityId);

}
