package cn.com.duiba.live.activity.center.api.remoteservice.user.point;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.user.point.UserPointRecordDto;
import cn.com.duiba.live.activity.center.api.param.user.point.UserPointRecordQueryParam;

import java.util.Date;
import java.util.List;

/**
 * @author zhuenhui
 * @date 2022-03-30 11：09
 * @description 用户积分流水 RPC
 */
@AdvancedFeignClient
public interface RemoteUserPointRecordService {

    /**
     * 新增流水记录
     *
     * @param dto 流水记录
     * @return 执行结果
     */
    int insert(UserPointRecordDto dto);

    /**
     * 新增流水记录
     *
     * @param dto 流水记录
     * @return id
     */
    Long insertGeneratedKeys(UserPointRecordDto dto);

    /**
     * 查询指定时间区间的流水记录
     *
     * @param userPointId 用户积分记录Id
     * @param startTime   开始时间
     * @param endTime     结束时间
     * @return 流水记录集合
     */
    List<UserPointRecordDto> listByPointIdAndTimeInterval(Long userPointId, Date startTime, Date endTime);

    /**
     * 查询最新的指定类型的流水记录
     *
     * @param userPointId 用户积分记录Id
     * @param channel     来源渠道
     *                    {@link cn.com.duiba.live.activity.center.api.enums.user.point.UserPointChannelEnum}
     * @return 流水记录
     */
    UserPointRecordDto findLastByPointIdAndChannel(Long userPointId, Integer channel);

    /**
     * 分页查询流水记录
     *
     * @param param 分页参数
     * @return 对应流水记录
     */
    List<UserPointRecordDto> listByParam(UserPointRecordQueryParam param);

    /**
     * 查询总数
     *
     * @param param 分页参数
     * @return 对应流水总数
     */
    int queryCount(UserPointRecordQueryParam param);

    /**
     * 批量新增
     *
     * @param dtoList
     * @return 结果
     */
    int batchInsert(List<UserPointRecordDto> dtoList);

}
