package cn.com.duiba.live.activity.center.api.dto.conf;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
public class ActResourceLocationDto implements Serializable{
    private static final long serialVersionUID = -4953522510030108483L;

    /**
     * id
     */
    private Long id;
    /**
     * 关联活动id
     */
    private Long actId;

    /**
     * 资源位类型
     *
     * @see cn.com.duiba.live.activity.center.api.enums.conf.ActResourceLocationTypeEnum
     */
    private Integer actResourceLocationType;

    /**
     * 标题
     */
    private String title;

    /**
     * 关联商品类型
     * @see cn.com.duiba.live.activity.center.api.enums.conf.AssociatedGoodsTypeEnum
     *
     */
    private Integer associatedGoodsType;

    /**
     *  * 链接内容列表，如果只有1个，就是1行1个的排列方式。如果有2个，就是1行2个的排列方式
     */
    private List<LinkInfoDto> linkInfos;

}