package cn.com.duiba.live.activity.center.api.enums.user.point;

import cn.com.duiba.live.activity.center.api.util.NumberUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author ouyang
 * @date 2022/04/24 13:55
 * @description 积分消费业务方
 */
@Getter
@AllArgsConstructor
public enum UserPointConsumeBizTypeEnum {

    DUIBA_CMS(1, "兑吧积分商城")
    ;

    /**
     * 类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 枚举Map K：type V：枚举
     */
    private static final Map<Integer, UserPointConsumeBizTypeEnum> ENUM_MAP = Collections.unmodifiableMap(
            Arrays.stream(UserPointConsumeBizTypeEnum.values()).collect(Collectors.toMap(UserPointConsumeBizTypeEnum::getType, Function.identity(), (v1, v2) -> v2))
    );

    /**
     * 根据类型查询枚举
     */
    public static UserPointConsumeBizTypeEnum getByType(Integer type) {
        if (NumberUtil.isNullOrLteZero(type)) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

}
