package cn.com.duiba.live.activity.center.api.remoteservice.user.point;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.user.point.consume.UserPointConsumeRecordDto;

/**
 * @author ouyang
 * @date 2022-04-24
 * @description 用户积分消费记录 RPC
 */
@AdvancedFeignClient
public interface RemoteUserPointConsumeRecordService {

    /**
     * 新增
     *
     * @param dto 用户积分消费记录
     * @return 主键Id
     */
    Long insert(UserPointConsumeRecordDto dto);

    /**
     * 更新
     *
     * @param dto 用户积分消费记录
     * @return 执行结果
     */
    int update(UserPointConsumeRecordDto dto);

    /**
     * 获取用户积分详情
     *
     * @param id  id
     * @return 用户积分消费记录
     */
    UserPointConsumeRecordDto findById(Long id);

    /**
     * 获取用户积分详情
     *
     * @param bizId  bizId
     * @return 用户积分消费记录
     */
    UserPointConsumeRecordDto findByBizId(String bizId,Integer bizType);

}
