package cn.com.duiba.live.activity.center.api.dto.answer;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
* 用户答题明细
 * @author duiba
 */

@Data
public class UserAnswerDetailDto implements Serializable {

    private static final long serialVersionUID = 1174465260096296356L;
    /**
    * 主键
    */
    private Long id;

    /**
    * 活动Id
    */
    private Long activityId;

    /**
    * 直播用户Id
    */
    private Long liveUserId;

    /**
    * 题目id
    */
    private Long questionId;

    /**
    * 答题时间
    */
    private Date answerTime;

    /**
    * 是否分享，1=已分享，0=未分享
    */
    private Integer share;

    /**
    * 分享奖励分数
    */
    private Integer sharePoints;

    /**
    * 参与奖励分数
    */
    private Integer joinPoints;

    /**
    * 答题奖励分数
    */
    private Integer answerPoints;

    /**
    * 是否答对，1=已答对，0=答错,2未答题
    */
    private Integer answerResult;

    /**
    * 奖励分数总数
    */
    private Integer pointsTotal;

    /**
    * 用户提交选项
    */
    private String userAnswer;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 更新时间
    */
    private Date gmtModified;


}

