package cn.com.duiba.live.activity.center.api.remoteservice.citic.mgm;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.citic.mgm.MgmUserWishDetailDto;

import java.util.List;

/**
 * @author zhuenhui
 * @date 2022/05/24 10:21
 * @description 中信MGM活动 - 用户心愿单商品详情 RPC 接口
 */
@AdvancedFeignClient
public interface RemoteMgmUserWishDetailService {

    /**
     * 新增/更新用户心愿单
     *
     * @param activityId  活动Id
     * @param liveUserId  用户Id
     * @param mgmGoodsIds 邀请商品Id列表
     * @param expire 有效天数
     * @return 执行结果
     */
    int saveOrUpdate(Long activityId, Long liveUserId, List<Long> mgmGoodsIds, Integer expire);

    /**
     * 查询用户心愿单列表
     *
     * @param activityId 活动Id
     * @param liveUserId 用户Id
     * @return 心愿单列表
     */
    List<MgmUserWishDetailDto> listByActivityIdAndLiveUserId(Long activityId, Long liveUserId);

    /**
     * 查询用户心愿单商品
     *
     * @param activityId 活动Id
     * @param liveUserId 用户Id
     * @param mgmGoodsId mgm商品Id
     * @return 心愿单商品
     */
    MgmUserWishDetailDto findUserMgmGoods(Long activityId, Long liveUserId, Long mgmGoodsId);

    /**
     * 批量删除用户心愿单
     *
     * @param activityId  活动Id
     * @param liveUserId  用户Id
     * @param mgmGoodsIds 邀请商品Id列表
     * @return 执行结果
     */
    int batchDelete(Long activityId, Long liveUserId, List<Long> mgmGoodsIds);

}
