package cn.com.duiba.live.activity.center.api.remoteservice.citic.mgm;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.citic.mgm.MgmUserWishRecordDto;

import java.util.Date;
import java.util.List;

/**
 * @author zhuenhui
 * @date 2022/05/24 10:21
 * @description 中信MGM活动 - 用户心愿单兑奖记录 RPC 接口
 */
@AdvancedFeignClient
public interface RemoteMgmUserWishRecordService {

    /**
     * 新增心愿单记录
     *
     * @param dto 心愿单记录
     * @return 执行记录
     */
    int insert(MgmUserWishRecordDto dto);

    /**
     * 更新心愿单记录
     *
     * @param id          主键
     * @param mgmGoodsId  邀请商品Id
     * @param exchangeNum 兑奖人数
     * @param receiveTime 领取时间
     * @return 执行结果
     */
    int updateReceiveRecord(Long id, Long mgmGoodsId, Integer exchangeNum, Date receiveTime);

    /**
     * 查询心愿单记录列表（根据创建时间倒序排）
     *
     * @param activityId 活动Id
     * @param liveUserId 用户Id
     * @return 心愿单记录列表
     */
    List<MgmUserWishRecordDto> listByActivityIdAndLiveUserId(Long activityId, Long liveUserId);


    /**
     * 查询用户最新的心愿单记录
     *
     * @param activityId 活动Id
     * @param liveUserId 用户Id
     * @return 心愿单记录
     */
    MgmUserWishRecordDto findLastUserWishRecord(Long activityId, Long liveUserId);

}
