package cn.com.duiba.live.activity.center.api.remoteservice.fission.achieve;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

/**
 * @author chengsiyi
 * @date 2021/8/10 10:12
 */
@AdvancedFeignClient
public interface RemoteLiveFissionAchieveStockService {

    /**
     * 扣除阶段一库存
     * @param recordId 用户记录ID
     * @param activityId 活动ID
     * @param goodsId 商品ID
     * @return 消耗结果
     */
    boolean reduceFirstStock(Long recordId, Long activityId, Long goodsId);

    /**
     * 回滚阶段一库存
     * 根据 recordId 查询到的记录ID，只有 STEP_FIRST 状态下才能回滚
     * @param recordId 记录ID
     * @param activityId 活动ID
     * @param goodsId 商品ID
     * @return 结果
     */
    boolean rollbackFirstStock(Long recordId, Long activityId, Long goodsId);

    /**
     * 消耗最终档库存
     * @param recordId 用户记录ID
     * @param activityId 活动ID
     * @param goodsId 商品ID
     * @return 消耗结果
     */
    boolean reduceFinalStock(Long recordId, Long activityId, Long goodsId);
}
