package cn.com.duiba.live.activity.center.api.enums.fission;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author chenhang
 * @date 2021/12/1 3:36 下午
 */
@Getter
@AllArgsConstructor
public enum BlindBoxGoodsStockStatusEnum {
    GOODS_STOCK_STATUS_NO(0, "没有库存"),
    GOODS_STOCK_STATUS_YES(1, "有库存");


    private final Integer status;
    private final String desc;

    private static  final Map<Integer, BlindBoxGoodsStockStatusEnum> ENUM_MAP;

    static {
        ENUM_MAP = Arrays.stream(BlindBoxGoodsStockStatusEnum.values()).collect(Collectors.toMap(BlindBoxGoodsStockStatusEnum::getStatus, Function.identity()));
    }

    public static BlindBoxGoodsStockStatusEnum getByStatus(Integer status) {
        if (status == null) {
            return null;
        }
        return ENUM_MAP.get(status);
    }

}
