package cn.com.duiba.live.activity.center.api.remoteservice.citic.mgm;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.citic.mgm.MgmUserDetailDto;

import java.util.Date;

/**
 * @author zhuenhui
 * @date 2022/05/24 10:21
 * @description 中信MGM活动 - 用户参与详情 RPC 接口
 */
@AdvancedFeignClient
public interface RemoteMgmUserDetailService {

    /**
     * 新增
     *
     * @param dto 用户详情
     * @return 执行结果
     */
    int insert(MgmUserDetailDto dto);

    /**
     * 根据活动Id和直播用户Id查询参与记录
     *
     * @param activityId 活动Id
     * @param liveUserId 用户Id
     * @return 参与记录
     */
    MgmUserDetailDto findByActivityIdAndLiveUserId(Long activityId, Long liveUserId);

    /**
     * 根据推荐码查询
     * @param promotionCode 参与码
     * @return 参与记录
     */
    MgmUserDetailDto findByPromotionCode(String promotionCode);

    /**
     * 更新登陆时间
     *
     * @param id        主键Id
     * @param loginTime 登陆时间
     * @return 执行结果
     */
    int updateLoginTime(Long id, Date loginTime);

    /**
     * 更新m2信息
     *
     * @param id     Id 主键
     * @param m2Info m2列表信息
     * @return 执行结果
     */
    int updateM2Info(Long id, String m2Info);

    /**
     * 更新已生效数
     *
     * @param id      主键Id
     * @param oldNum  老的生效数
     * @param incrNum 新增生效数
     * @return 执行结果
     */
    int updateEffectiveNum(Long id, Integer oldNum, Integer incrNum);

    /**
     * 增加用户已兑奖数
     *
     * @param id      主键Id
     * @param incrNum 新增兑奖数
     * @return 执行结果
     */
    int incrExchangeNum(Long id, Integer incrNum);

}
