package cn.com.duiba.live.activity.center.api.dto.conf;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
public class ActResourceLocationDto implements Serializable{
    private static final long serialVersionUID = -4953522510030108483L;

    /**
     * id
     */
    private Long id;
    /**
     * 关联活动id
     */
    private Long actId;

    /**
     * 资源位类型
     *
     * @see cn.com.duiba.live.activity.center.api.enums.conf.ActResourceLocationTypeEnum
     */
    private Integer actResourceLocationType;
    /**
     * 标题
     */
    private String title;
    /**
     * 是否开启拦截返回
     */
    private Boolean returnIntercept;
    /**
     * 拦截弹窗图片
     */
    private String interceptImg;
    /**
     * 拦截弹窗链接类型
     *
     * @see cn.com.duiba.live.activity.center.api.enums.conf.LinkToTypeEnum
     */
    private Integer linkToType;
    /**
     * 拦截弹窗跳转活动类型
     *
     * @see cn.com.duiba.live.activity.center.api.enums.fission.FissionActivityTypeEnum
     */
    private Integer actType;
    /**
     * 拦截弹窗跳转活动id
     */
    private Integer interceptToActId;
    /**
     * 链接信息列表
     */
    private List<LinkInfoDto> linkInfos;

}