package cn.com.duiba.live.activity.center.api.enums.conf;


import lombok.Getter;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * 链接通往了类型枚举类
 */
@Getter
public enum BelongToTypeEnum {
    ACT_RESOURCE_LOCATION(1, "活动页资源位"),
    SUB_RESOURCE_LOCATION(2, "订阅页资源位"),
    ;


    private Integer type;

    private String desc;

    BelongToTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static final Map<Integer, BelongToTypeEnum> ENUM_MAP = new HashMap<>();


    static {
        for (BelongToTypeEnum linkToType : values()) {
            ENUM_MAP.put(linkToType.getType(), linkToType);
        }
    }

    public static BelongToTypeEnum getByType(Integer key) {
        if (key == null) {
            return null;
        }
        return ENUM_MAP.get(key);
    }

    /**
     * 是否包含
     *
     * @param key
     * @return
     */
    public static boolean contains(Integer key) {
        if (null == key) {
            return false;
        }
        for (BelongToTypeEnum enumVal : BelongToTypeEnum.values()) {
            if (Objects.equals(enumVal.getType(), key)) {
                return true;
            }
        }
        return false;
    }

}
