package cn.com.duiba.live.activity.center.api.dto.user.point.add;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description
 * @Date 2022/6/9 17:14
 * @Author LuHui
 */
@Data
public class UserPointAddRecordDto implements Serializable {

    private static final long serialVersionUID = 331421822786769343L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 公司Id
     */
    private Long companyId;

    /**
     * 直播用户Id
     */
    private Long liveUserId;

    /**
     * 增加积分数
     */
    private Integer addPointNum;

    /**
     * 订单状态
     * @see cn.com.duiba.live.activity.center.api.enums.user.point.UserPointAddOrderStatusEnum
     */
    private Integer orderStatus;

    /**
     * 流水记录id(扣减通知回调成功后关联)
     */
    private Long userPointRecordId;

    /**
     * 订单业务方类型
     * @see cn.com.duiba.live.activity.center.api.enums.user.point.UserPointAddBizTypeEnum
     */
    private Integer bizType;

    /**
     * 业务方订单id
     */
    private String bizId;

    /**
     * 业务订单信息
     */
    private String bizJson;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}
