package cn.com.duiba.live.activity.center.api.enums.community.invitation;

import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author dugq
 * @date 2022/6/30 11:12 上午
 */
@Getter
public enum CommunityConfEnum {
    REGIONAL_RESTRICTIONS("Regional","参与活动的区域限制"),

    ;
    private final String confName;

    private final String desc;

    CommunityConfEnum(String confName, String desc) {
        this.confName = confName;
        this.desc = desc;
    }

    private static final Map<String,CommunityConfEnum> all;

    static {
        final Map<String, CommunityConfEnum> allMap = Arrays.stream(values()).collect(Collectors.toMap(CommunityConfEnum::getConfName, Function.identity()));
        all = Collections.unmodifiableMap(allMap);
    }

    public static CommunityConfEnum of(String name){
        return all.get(name);
    }

}
