package cn.com.duiba.live.activity.center.api.util;

import cn.hutool.core.net.url.UrlBuilder;
import cn.hutool.core.util.CharsetUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

/**
 * @Author xujing
 * @Date 2021/12/13 8:21 下午
 */
@Slf4j
public class DuibaLinkUtil {
    /**
     * 获取兑吧积分商城链接上的itemId
     *
     * @param url eg:https://live.duiba.com.cn/kjy/live/autologin?appKey=2t7NN9DNwncfG2URQhKNZ5oX2eAj&dbredirect=https%3A%2F%2F85545.activity-8.m.duiba.com.cn%2Fmobile%2FappItemDetail%3FappItemId%3D184434008150289%26dbnewopen
     * @return
     */
    public static Long getItemId(String url) {
        try {
            if(StringUtils.isBlank(url)){
                return null;
            }
            UrlBuilder builder = UrlBuilder.ofHttp(url, CharsetUtil.CHARSET_UTF_8);
            CharSequence dbredirect = builder.getQuery().get("dbredirect");
            if (dbredirect != null) {
                UrlBuilder subUrl = UrlBuilder.ofHttp(dbredirect.toString(), CharsetUtil.CHARSET_UTF_8);
                CharSequence appItemId = subUrl.getQuery().get("appItemId");
                if (appItemId != null) {
                    return Long.parseLong(appItemId.toString());
                }
            }

        } catch (Exception e) {
            log.error("获取兑吧积分商城链接出错 url={}", url, e);
        }
        return null;
    }
}
