package cn.com.duiba.live.activity.center.api.dto.flipword;

import cn.com.duiba.live.activity.center.api.enums.live.LiveRedPacketStatusEnum;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
* 翻牌集字红包配置
*/
@Data
@NoArgsConstructor
@AllArgsConstructor
@Builder
public class LiveFlipWordRedConfigDto implements Serializable {

    private static final long serialVersionUID = -8218602663543929333L;
    /**
    * 配置id：活动Id
    */
    private Long configId;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModified;

    /**
    * 主键
    */
    private Long id;

    /**
    * 红包金额
    */
    private BigDecimal redAmount;

    /**
    * 红包数量
    */
    private Integer redNum;

    /**
     * 红包状态{@link LiveRedPacketStatusEnum}
     */
    private Integer redStatus;

    /**
     * 活动id
     */
    private Long activityId;

}

