package cn.com.duiba.live.activity.center.api.remoteservice.multiprize;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.multiprize.MultiPrizeGoodsDto;

import java.util.List;

/**
 * @author chengsiyi
 * @date 2021/9/17 11:19
 */
@AdvancedFeignClient
public interface RemoteMultiPrizeGoodsService {
    /**
     * 保存商品
     *
     * @param activityId 直播ID
     * @param goods      商品信息
     * @return
     */
    int saveGoods(Long activityId, List<MultiPrizeGoodsDto> goods);

    int updateById(MultiPrizeGoodsDto dto);

    MultiPrizeGoodsDto getById(Long id);

    /**
     * 获取直播间爆款商品
     *
     * @param activityId 直播间ID
     * @return 商品
     */
    List<MultiPrizeGoodsDto> getByActivityId(Long activityId);

    /**
     * 扣商品库存
     *
     * @param activityId 活动ID
     * @param goodsId    商品ID
     * @return
     */
    Boolean reduceOneStock(Long activityId, Long goodsId);

    /**
     * 扣商品虚拟库存
     *
     * @param activityId 活动ID
     * @param goodsId    商品ID
     * @return
     */
    Boolean reduceOneVirtualStock(Long activityId, Long goodsId);
}
