package cn.com.duiba.live.activity.center.api.dto.conf;

import lombok.Data;

import java.io.Serializable;

@Data
public class LinkInfoDto implements Serializable {
    private static final long serialVersionUID = -4953522211303048483L;

    private Long id;
    /**
     * 连接属于页面类型
     *
     * @see cn.com.duiba.live.activity.center.api.enums.conf.BelongToTypeEnum
     */
    private Integer belongToType;

    /**
     * 外部id
     * 如果belongToType =ACT_RESOURCE_LOCATION，那么就是活动id
     * 如果belongToType =SUB_RESOURCE_LOCATION，那么就是直播id
     */
    private Long foreignId;

    /**
     * 连接类型
     *
     * @see cn.com.duiba.live.activity.center.api.enums.conf.LinkToTypeEnum
     */
    private Integer linkToType;

    /**
     * 活动id
     */
    private Long activityId;

    /**
     * 链接展示图片
     */
    private String linkImg;

    /**
     * 活动类型
     *
     * @see cn.com.duiba.live.activity.center.api.enums.fission.FissionActivityTypeEnum
     */
    private Integer activityType;

}
