package cn.com.duiba.live.activity.center.api.dto.fission.achieve;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import javax.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Date;

/**
* 裂变活动免费领配置
*/
@Data
@Builder
@NoArgsConstructor
@AllArgsConstructor
public class FissionAchieveConfigDto implements Serializable {

    private static final long serialVersionUID = -8970414432466648168L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 商品ID
     */
    private Long goodsId;

    /**
    * 活动ID
    */
    @NotNull(message = "活动id不能为空")
    private Long activityId;


    /**
    * 阶段1商品金额
    */
    @NotNull(message = "阶段1商品金额不能为空")
    private Integer firstGoodsMoney;

    /**
    * 阶段1销量
    */
    @NotNull(message = "阶段1销量不能为空")
    private Integer firstSales;

    /**
    * 阶段1库存
    */
    @NotNull(message = "阶段1库存不能为空")
    private Integer firstStock;

    /**
    * 阶段1邀请阈值
    */
    @NotNull(message = "阶段1邀请阈值不能为空")
    private Integer firstThreshold;
    /**
     * 最终档阈值
     */
    @NotNull(message = "最终档阈值不能为空")
    private Integer finalThreshold;
    /**
     * 最终档销量
     */
    @NotNull(message = "最终档销量不能为空")
    private Integer finalSales;

    /**
     * 最终档库存
     */
    @NotNull(message = "最终档库存不能为空")
    private Integer finalStock;

    /**
     * 排序值
     */
    @NotNull(message = "排序值不能为空")
    private Integer sortNum;

    /**
    * 创建时间
    */
    private Date gmtCreate;

    /**
    * 修改时间
    */
    private Date gmtModified;


}

