package cn.com.duiba.live.activity.center.api.remoteservice.red;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.red.LiveRedResultDto;

import java.util.List;
import java.util.Map;

/**
 * 直播红包
 * @author dugq
 * @date 2020-07-03
 */
@AdvancedFeignClient
public interface RemoteLiveRedService {

    /**
     * 领取结果
     * @param liveId 直播ID
     * @param confId 红包ID
     * @return 领取结果列表
     */
    List<LiveRedResultDto> getResultList(Long liveId, Long confId);

    /**
     * 用户邀请特权标记
     * @param liveId 直播ID
     * @param liveUserIds 用户ID
     */
    void markInvitePrivilege(Long liveId, List<Long> liveUserIds);

    /**
     * 获取直播间特权用户
     * @param liveId 直播ID
     * @return
     */
    Map<Long, Integer> getLiveInvitePrivilege(Long liveId);

    /**
     * 获取用户特权标记
     * @param liveId 直播ID
     * @param liveUserId 用户ID
     * @return
     */
    Integer getUserInvitePrivilege(Long liveId, Long liveUserId);

    /**
     * 获取给定用户的邀请特权
     * @param liveId 直播间ID
     * @param liveUserIds 给定用户
     * @return 直播ID，次数
     */
    Map<Long, Integer>  getUsersInvitePrivilege(Long liveId, List<Long> liveUserIds);
}
