package cn.com.duiba.live.activity.center.api.enums.citic;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang.StringUtils;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author zhuenhuiz
 * @date 2022/02/24 14:15
 * @description 中信总行 - 业务类型枚举
 */
@Getter
@AllArgsConstructor
public enum CiticBizEnum {

    /**
     * 信e通用户单独运营
     * 从信e通进入直播间的用户才能中奖
     */
    WHITE_LIST_REWARD("zxtag1", "信e通用户白名单中奖"),
    ;

    /**
     * 中信方面的特定业务参数
     * 参数拼接在小程序path上, 兑吧侧根据参数是否为空决定业务逻辑
     */
    private final String code;

    /**
     * 业务描述
     */
    private final String desc;

    /**
     * 枚举Map
     */
    private static final Map<String, CiticBizEnum> MAP = Collections.unmodifiableMap(
            Arrays.stream(values()).collect(Collectors.toMap(CiticBizEnum::getCode, Function.identity(), (v1, v2) -> v2))
    );

    /**
     * 根据code获取枚举
     */
    public static CiticBizEnum getByCode(String code) {
        if (StringUtils.isBlank(code)) {
            return null;
        }
        return MAP.get(code);
    }

}
