package cn.com.duiba.live.activity.center.api.enums.user.point;

import cn.com.duiba.live.activity.center.api.util.NumberUtil;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author zhuenhui
 * @date 2022/03/30 13:55
 * @description 用户积分变更类型
 */
@Getter
@AllArgsConstructor
public enum UserPointChangeTypeEnum {

    INCR(1, "增加"),
    DECR(2, "减少"),
    ROLLBACK(3, "回滚"),
    ;

    /**
     * 变更类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 枚举Map K：type V：枚举
     */
    private static final Map<Integer, UserPointChangeTypeEnum> ENUM_MAP = Collections.unmodifiableMap(
            Arrays.stream(UserPointChangeTypeEnum.values()).collect(Collectors.toMap(UserPointChangeTypeEnum::getType, Function.identity(), (v1, v2) -> v2))
    );

    /**
     * 根据类型查询枚举
     */
    public static UserPointChangeTypeEnum getByType(Integer type) {
        if (NumberUtil.isNullOrLteZero(type)) {
            return null;
        }
        return ENUM_MAP.get(type);
    }

}
