package cn.com.duiba.live.activity.center.api.dto.lottery;

import cn.com.duiba.live.activity.center.api.enums.lottery.LiveLotteryCodeSourceEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * 直播抽奖码
 * @author kjj mybatis generator
 * @date 2020-06-02
 */
@Data
public class LiveLotteryCodeDto implements Serializable {

    private static final long serialVersionUID = 15910913610689784L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 直播访客userId
     */
    private Long liveVisitorId;

    /**
     * 互动类型：1-预约，2-签到, 3-关注直播间，4-累计观看，5-邀请好友
     * @see LiveLotteryCodeSourceEnum
     */
    private Integer codeSource;

    /**
     * 是否使用：0-未使用，1-已使用
     * @see cn.com.duiba.kjy.livecenter.api.enums.BooleanEnum
     */
    private Integer codeUsed;

    /**
     * 被邀请人直播用户ID（仅在邀请好友抽奖码时可能有值）
     */
    private Long inviteeId;

    /**
     * 靓码ID
     */
    private Long prettyCodeId;
}
