package cn.com.duiba.live.activity.center.api.enums.conf;


import lombok.Data;
import lombok.Getter;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

/**
 * 链接通往了类型枚举类
 */
@Getter
public enum LinkToTypeEnum {
    ACTIVITY(1, "营销活动"),
    ;


    private Integer type;

    private String desc;

    LinkToTypeEnum(Integer type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    private static final Map<Integer, LinkToTypeEnum> ENUM_MAP = new HashMap<>();


    static {
        for (LinkToTypeEnum linkToType : values()) {
            ENUM_MAP.put(linkToType.getType(), linkToType);
        }
    }

    public static LinkToTypeEnum getByType(Integer key) {
        if (key == null) {
            return null;
        }
        return ENUM_MAP.get(key);
    }

    /**
     * 是否包含
     *
     * @param key
     * @return
     */
    public static boolean contains(Integer key) {
        if (null == key) {
            return false;
        }
        for (LinkToTypeEnum enumVal : LinkToTypeEnum.values()) {
            if (Objects.equals(enumVal.getType(), key)) {
                return true;
            }
        }
        return false;
    }

}
