package cn.com.duiba.live.activity.center.api.param.lottery;

import cn.com.duiba.kjy.livecenter.api.param.common.PageQuery;
import com.alipay.api.domain.DataEntry;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 直播抽奖码
 * @author kjj mybatis generator
 * @date 2020-06-02
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class LiveLotteryCodeSearchParam extends PageQuery {

    private static final long serialVersionUID = 159109136107061L;

    /**
     * 直播ID
     */
    private Long liveId;

    /**
     * 直播访客userId
     */
    private Long liveVisitorId;

    /**
     * 靓码ID
     */
    private Long prettyCodeId;

    /**
     * 互动类型：1-预约，2-签到, 3-关注直播间，4-累计观看，5-邀请好友
     */
    private Integer codeSource;

    /**
     * 把互动类型前置
     */
    private Integer orderGoTopCodeSource;

    /**
     * 是否使用：0-未使用，1-已使用
     */
    private Integer codeUsed;

    /**
     * 用户上次进入时间
     */
    private Date entryTime;

}
