package cn.com.duiba.live.activity.center.api.dto.rights;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @Description：
 * @Author：jibin
 * @Date：2021/11/16 上午11:30
 * @Versiion：1.0
 */
@Data
public class RightsManagerDto implements Serializable {
    private static final long serialVersionUID = 2855014752018441530L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 权益名称
     */
    private String rightName;

    /**
     * 副标题
     */
    private String subTitle;

    /**
     * 公司id
     */
    private Long companyId;

    /**
     * 权益分类 1-直播间权益 2-信用卡权益
     */
    private Integer rightType;

    /**
     * 开始时间
     */
    private Date startTime;

    /**
     * 结束时间
     */
    private Date endTime;

    /**
     * 权益图片
     */
    private String rightImage;

    /**
     * 跳转类型 0-不跳转 1-链接跳转 2-图片跳转
     */
    private Integer jumpType;

    /**
     * 权益跳转地址
     */
    private String jumpUrl;

    /**
     * 状态 0-未启用 1-启用
     */
    private Integer publishState;
}

