package cn.com.duiba.live.activity.center.api.dto.seckill;

import cn.com.duiba.live.activity.center.api.enums.sekill.SeckillTypeEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * @Author xujing
 * @Date 2021/11/2 10:15 上午
 */
@Data
public class SeckillConfigDto implements Serializable {

    private static final long serialVersionUID = 5521242186394415240L;

    /**
     * 活动id
     */
    private Long id;

    /**
     * 公司id
     */
    private Long companyId;

    /**
     * 秒杀开始时间
     * 如果是单场秒杀活动 yyyy-MM-dd HH:mm:ss
     * 如果是按天循环秒杀 HH:mm:ss
     */
    private String startTime;

    /**
     * 秒杀类型
     * 1 按天循环秒杀
     * 2 单场秒杀
     * @see SeckillTypeEnum
     */
    private Integer seckillType;

    /**
     * 积分商城appKey
     */
    private String appKey;

    /**
     * 积分商城appSecret
     */
    private String appSecret;

    /**
     * 主推款商品id JSON数组格式
     */
    private String mainGoodIds;

    /**
     * 普通款商品id JSON数组格式
     */
    private String commonGoodIds;

    /**
     * 秒杀背景图
     */
    private String backgroundImage;
}
