package cn.com.duiba.live.activity.center.api.remoteservice.red;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.red.LiveStatisticsRedPacketDto;

/**
 * @author chengsiyi
 * @date 2021/1/12 15:08
 */
@AdvancedFeignClient
public interface RemoteLiveStatisticsRedPacketService {

    /**
     * 根据直播ID查询
     * @param liveId 直播ID
     * @return 直播配置-红包统计数据
     */
    LiveStatisticsRedPacketDto selectByLiveId(Long liveId);

    /**
     * 新增
     * @param dto 直播配置-红包统计数据
     * @return 执行结果
     */
    int insert(LiveStatisticsRedPacketDto dto);

    /**
     * 根据直播ID更新
     * @param dto 直播配置-红包统计数据
     * @return 执行结果
     */
    int updateByLiveId(LiveStatisticsRedPacketDto dto);
}
