package cn.com.duiba.live.activity.center.api.remoteservice.rights;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.rights.RightsManagerDto;
import cn.com.duiba.live.activity.center.api.param.rights.RightsManagerSearchParam;

import java.util.List;

@AdvancedFeignClient
public interface RemoteRightsManagerService {

    /**
     * 查询数量
     * @param param 查询条件
     * @return 数目
     */
    Long countByParam(RightsManagerSearchParam param);

    /**
     * 分页查询
     * @param param 查询条件
     * @return 列表
     */
    List<RightsManagerDto> pageByParam(RightsManagerSearchParam param);

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    RightsManagerDto queryById(Long id);


    /**
     * 新增数据
     *
     * @param rightsManagerDto 实例对象
     * @return 实例对象
     */
    long insert(RightsManagerDto rightsManagerDto);

    /**
     * 修改数据
     *
     * @param rightsManagerDto 实例对象
     * @return 实例对象
     */
    int update(RightsManagerDto rightsManagerDto);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    int deleteById(Long id);
}
