package cn.com.duiba.live.activity.center.api.remoteservice.seckill;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.seckill.SecKillActForFrontDto;
import cn.com.duiba.live.activity.center.api.dto.seckill.SeckillConfigDto;

import java.util.List;

/**
 * @Author xujing
 * @Date 2021/11/2 11:04 上午
 */
@AdvancedFeignClient
public interface RemoteSeckillConfigService {

    /**
     * 根据公司id查询秒杀配置详情
     * @param companyId
     * @return
     */
    SeckillConfigDto findByCompanyId(Long companyId);

    /**
     * 根据appKey appSecret查询列表
     * @param appKey
     * @param appSecret
     * @return
     */
    List<SecKillActForFrontDto> listSeckillGoods(String appKey, String appSecret);

    /**
     * 查询所有活动
     * @return
     */
    List<SeckillConfigDto> listAll();
}
