package cn.com.duiba.live.activity.center.api.remoteservice.user.point;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.user.point.add.UserPointAddRecordDto;

/**
 * @Description 用户积分增加记录 RPC
 * @Date 2022/6/9 17:10
 * @Author LuHui
 */
@AdvancedFeignClient
public interface RemoteUserPointAddRecordService {

    /**
     * 插入用户积分增加记录
     * @param userPointAddRecordDto
     * @return
     */
    Long insert(UserPointAddRecordDto userPointAddRecordDto);

    /**
     * 更新用户积分增加记录
     * @param userPointAddRecordDto
     * @return
     */
    Integer update(UserPointAddRecordDto userPointAddRecordDto);


    /**
     * 查询用户积分增加记录
     * @param id
     * @return
     */
    UserPointAddRecordDto findById(Long id);
}
