package cn.com.duiba.live.activity.center.api.enums.flipword;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author zhuenhui
 * @date 2021/07/08 12:08 下午
 * @description 翻牌集字 - 错误码
 */
@Getter
@AllArgsConstructor
public enum FlipWordFailCodeEnum {
    /**
     * 通用错误码
     */
    CONF_NOT_FOUND(11, "翻牌集字配置未找到"),
    RECORD_NOT_FIND(12, "用户记录未找到"),
    FILTER_COMMON_FAIL(13, "红包通用过滤失败"),

    /**
     * 翻牌错误码
     */
    COLLECT_FINISHED(21, "集字已完成"),
    CURRENT_POS_RECEIVED(22, "当前位置已领取过"),
    NO_FLIP_CHANCE(23, "没有翻牌机会"),
    NOT_ENOUGH_FISSION(24, "助力人数不足"),
    NOT_RECEIVE_FRONT(25, "未领完4张牌"),
    NOT_ENOUGH_STOCK(26, "库存不足"),
    POS_ERROR(27, "翻牌位置错误"),

    /**
     * 开红包
     */
    NOT_COLLECT_FINISHED(30, "用户状态 - 需要为集卡完成状态"),
    OPEN_OR_ABORT(31, "用户状态 - 已经开启过红包"),

    CENTER_COMPANY_FAIL(200014, "企业付款到零钱结果失败"),
    CENTER_COMPANY_RECEIVING(200015, "企业付款到零钱结果领取中"),
    CENTER_COMPANY_ACCOUNT_SIMPLE_BAN(200016, "用户未实名认证"),
    ;

    private final Integer code;
    private final String desc;

}
