package cn.com.duiba.live.activity.center.api.remoteservice.fission.blindbox;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.fission.blindbox.BlindBoxConfigDto;
import cn.com.duiba.live.activity.center.api.dto.fission.blindbox.BlindBoxGoodsConfigDto;

import java.util.List;

/***
 * @author chenhang
 * @since 2021-11-25 15:23:10
 */
@AdvancedFeignClient
public interface RemoteBlindBoxConfigService {

    /**
     * 通过ID查询单条数据
     *
     * @param id 主键
     * @return 实例对象
     */
    BlindBoxConfigDto queryById(Long id);


    /**
     * 新增数据
     *
     * @param dto 实例对象
     * @return 自动生成的主键
     */
    Long insert(BlindBoxConfigDto dto);

    /**
     * 修改数据
     *
     * @param dto 实例对象
     * @return 实例对象
     */
    int update(BlindBoxConfigDto dto);

    /**
     * 通过主键删除数据
     *
     * @param id 主键
     * @return 是否成功
     */
    int deleteById(Long id);

    /**
     * 获取盲盒配置列表
     * @param liveId 直播id
     * @return 盲盒配置列表
     */
    List<BlindBoxGoodsConfigDto> getBlindBoxList(Long liveId);

    /**
     * 根据活动id获取对应的盲盒配置
     */
    BlindBoxConfigDto getByActivityId(Long activityId);


}
