package cn.com.duiba.live.activity.center.api.remoteservice.user.point;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.live.activity.center.api.dto.user.point.UserPointConfigDto;
import cn.com.duiba.live.activity.center.api.param.user.point.UserPointConfigQueryParam;
import java.util.List;

/**
 * @author ouyang
 * @date 2022-04-07 11：09
 * @description 用户积分配置 RPC
 */
@AdvancedFeignClient
public interface RemoteUserPointConfigService {

    /**
     * 保存用户积分规则
     *
     * @param dto 用户积分详情
     * @return 执行结果
     */
    Long save(UserPointConfigDto dto);

    /**
     * 获取用户积分详情
     *
     * @param companyId  公司Id
     * @return 用户积分配置列表
     */
    List<UserPointConfigDto> findByCompanyId(Long companyId);

    /**
     * 获取用户积分详情
     *
     * @param id  id
     * @return 用户积分配置列表
     */
    UserPointConfigDto findById(Long id);

    /**
     * 获取用户积分详情列表
     *
     * @param ids  ids
     * @return 用户积分配置列表
     */
    List<UserPointConfigDto> findByIdList(List<Long> ids);


    /**
     * 分页列表
     *
     * @param param 查询参数
     * @return 分页列表
     */
    List<UserPointConfigDto> selectPageList(UserPointConfigQueryParam param);

    /**
     * 查询数据条数
     * @param param 查询参数
     * @return count
     */
    Long selectCount(UserPointConfigQueryParam param);


}
